'use strict';

export const dateTime = {
    comparator(segmentA, segmentB) {
        const datetimeA = segmentA.datetime;
        const datetimeB = segmentB.datetime;

        if (!datetimeA) {
            return 1;
        }

        if (!datetimeB) {
            return -1;
        }

        return datetimeA.localeCompare(datetimeB);
    },
    intervalComparator() {
        return 0;
    },
};

export const time = {
    comparator(segmentA, segmentB) {
        const momentA = segmentA.moment;
        const momentB = segmentB.moment;

        const hoursA = momentA.hours();
        const hoursB = momentB.hours();

        return hoursA === hoursB
            ? momentA.minutes() - momentB.minutes()
            : hoursA - hoursB;
    },
    intervalComparator() {
        return 0;
    },
};
