import searchSortKeyset from '../../i18n/search-sort';

export const SORTING_TYPES = {
    DEPARTURE: 'departure',
    ARRIVAL: 'arrival',
    DURATION: 'duration',
    PRICE: 'price',
};

export const SORTERS = {
    TIME: 'time',
    DATETIME: 'dateTime',
    DURATION: 'duration',
    PRICE: 'price',
};

export const ASCENDING_SORT = 'ascending';
export const DESCENDING_SORT = 'descending';

export const DEFAULT_SORT = {
    by: SORTING_TYPES.DEPARTURE,
    reverse: false,
};

export const SORT_FIELDS = [
    SORTING_TYPES.DEPARTURE,
    SORTING_TYPES.ARRIVAL,
    SORTING_TYPES.DURATION,
    SORTING_TYPES.PRICE,
];

export function getSortFieldOptions() {
    return SORT_FIELDS.map(value => ({
        value,
        title: searchSortKeyset(`sort-by-${value}`),
    }));
}

export function getSortDirectionOptions(sortField) {
    return [ASCENDING_SORT, DESCENDING_SORT].map(value => ({
        value,
        title: searchSortKeyset(`sort-direction-${sortField}-${value}`),
    }));
}
