import IStationStop from '../../interfaces/state/station/IStationStop';
import ISuggestData from '../../interfaces/components/suggest/ISuggestData';
import IStopSuggestElement from '../../interfaces/lib/station/IStopSuggestElement';

import getRegexpForSuggestStops from './getRegexpForSuggestStops';

// Возвращает функцию для получения списка остановок для саджестов фильтра по остановке
export default function getFunctionForGetDataStationSuggest(
    stops: IStationStop[],
    limit: number,
): (stopText: string) => ISuggestData<IStopSuggestElement> {
    return stopText => {
        const regExp = getRegexpForSuggestStops(stopText);

        const filteredStops: IStationStop[] = stops
            .map(stop => {
                const matchWeight =
                    (regExp.test(stop.title) ? 2 : 0) +
                    (stop.settlement && regExp.test(stop.settlement) ? 1 : 0);

                return {
                    ...stop,
                    matchWeight,
                };
            })
            .filter(({matchWeight}) => matchWeight > 0)
            .sort((a, b) => {
                if (a.matchWeight > b.matchWeight) {
                    return -1;
                }

                if (a.matchWeight < b.matchWeight) {
                    return 1;
                }

                if (a.majority < b.majority) {
                    return -1;
                }

                if (a.majority > b.majority) {
                    return 1;
                }

                const aTitle = a.title.toLowerCase();
                const bTitle = b.title.toLowerCase();

                if (aTitle > bTitle) {
                    return 1;
                }

                if (aTitle < bTitle) {
                    return -1;
                }

                return 0;
            })
            .slice(0, limit);

        return {
            elements: filteredStops.map(stop => ({
                id: stop.id,
                title: stop.title,
                subtitle: stop.settlement,
            })),
        };
    };
}
