import IRouteStation from '../../interfaces/state/station/IRouteStation';
import StationEventList from '../../interfaces/state/station/StationEventList';

export default function getPlaneDirection(
    routeStations: IRouteStation[],
    event: StationEventList,
): string {
    const routeStationsLength = routeStations.length;

    if (!routeStationsLength) {
        return '';
    }

    if (event === StationEventList.departure) {
        return (
            routeStations[routeStationsLength - 1]?.settlement ||
            routeStations[routeStationsLength - 1]?.title ||
            ''
        );
    }

    if (event === StationEventList.arrival) {
        return routeStations[0]?.settlement || routeStations[0]?.title || '';
    }

    return '';
}
