import StationSubtype from '../../interfaces/state/station/StationSubtype';
import StationType from '../../interfaces/state/station/StationType';

// Возвращает возможные подтипы станций для типа станции
export default function getPossibleSubtypes(
    type?: StationType,
): StationSubtype[] {
    if (!type) {
        return Object.values(StationSubtype);
    }

    switch (type) {
        case StationType.railroad:
            return [
                StationSubtype.train,
                StationSubtype.suburban,
                StationSubtype.tablo,
            ];
        case StationType.plane:
            return [StationSubtype.plane];
        case StationType.bus:
        case StationType.water:
            return [StationSubtype.schedule];
    }
}
