import AllScheduleThreadType from '../../interfaces/state/station/AllScheduleThreadType';
import IStationScheduleThread from '../../interfaces/state/station/IStationScheduleThread';
import IStationScheduleIntervalThread from '../../interfaces/state/station/IStationScheduleIntervalThread';
import IStationStopFilter from '../../interfaces/state/station/IStationStopFilter';

import isScheduleThread from './isScheduleThread';
import isScheduleIntervalThread from './isScheduleIntervalThread';

type Threads = {
    threads: IStationScheduleThread[];
    intervalThreads: IStationScheduleIntervalThread[];
};

// Производит фильтрацию ниток и разбивает их на интервальные и обычные
export default function getScheduleThreads(
    threads: AllScheduleThreadType[],
    stopFilter: IStationStopFilter | null,
): Threads {
    return threads.reduce<Threads>(
        (result, thread) => {
            if (stopFilter && !stopFilter.threads[thread.canonicalUid]) {
                return result;
            }

            if (isScheduleThread(thread)) {
                result.threads.push(thread);
            }

            if (isScheduleIntervalThread(thread)) {
                result.intervalThreads.push(thread);
            }

            return result;
        },
        {threads: [], intervalThreads: []},
    );
}
