import {TransportType} from '../transportType';
import ITransportSubtype from '../../interfaces/state/station/ITransportSubtype';
import TransportSubtypeCode from '../../interfaces/state/station/TransportSubtypeCode';

import stationKeyset from '../../i18n/station';

export default function getSubtitle(
    transportType: TransportType,
    isAeroExpress?: boolean,
    transportSubtype?: ITransportSubtype,
    deluxeTrainTitle?: string,
): string | undefined {
    if (transportType === TransportType.train) {
        return deluxeTrainTitle || transportSubtype?.title;
    }

    if (isAeroExpress) {
        return stationKeyset('aeroexpress');
    }

    return transportSubtype?.code !== TransportSubtypeCode.suburban
        ? transportSubtype?.title
        : undefined;
}
