import StationSubtype from '../../interfaces/state/station/StationSubtype';
import {TransportType} from '../transportType';

// Нужна для формирования корректных ссылок на страницу станции по типу транспорта.
// Например, для формирования ссылки для станций сегментов.
export default function getSubtypeByTransportType(
    transportType: TransportType,
): StationSubtype {
    switch (transportType) {
        case TransportType.bus:
        case TransportType.water:
            return StationSubtype.schedule;
        case TransportType.train:
            return StationSubtype.train;
        case TransportType.suburban:
            return StationSubtype.suburban;
        case TransportType.plane:
            return StationSubtype.plane;
    }
}
