import AllThreadType from '../../interfaces/state/station/AllThreadType';
import IThreadPlane from '../../interfaces/state/station/IThreadPlane';

import isPlaneThread from './isPlaneThread';

/* Вспомогательная функция. Единственное назначение - без лишнего оверхеда подсказать typescript-у,
   что массив состоит из конкретных типов. В реальности, в стэйте, нитки на странице станции могут быть
   только одного типа, так что нет нужды проверять весь массив. */
export default function isPlaneThreads(
    threads: AllThreadType[],
): threads is IThreadPlane[] {
    if (threads.length === 0) {
        return true;
    }

    return isPlaneThread(threads[0]);
}
