import AllThreadType from '../../interfaces/state/station/AllThreadType';
import IThreadRailroad from '../../interfaces/state/station/IThreadRailroad';

import isRailroadThread from './isRailroadThread';

/* Вспомогательная функция. Единственное назначение - без лишнего оверхеда подсказать typescript-у,
   что массив состоит из конкретных типов. В реальности, в стэйте, нитки на странице станции могут быть
   только одного типа, так что нет нужды проверять весь массив. */
export default function isRailroadThreads(
    threads: AllThreadType[],
): threads is IThreadRailroad[] {
    if (threads.length === 0) {
        return true;
    }

    return isRailroadThread(threads[0]);
}
