import {ALL_TYPE} from '../transportType';

import getSuggestsType from './getSuggestsType';

/**
 * Возвращает данные для dataProvider'а формы поиска
 * @param {string} field - принимает значение 'from' и 'to'
 * @param {Object} suggests
 * @param {string} language
 * @param {string} nationalVersion
 * @param {Object} clientSettlement
 * @param {Object} from
 * @param {Object} to
 * @param {string} transportType
 * @return {Object}
 */
export default function buildSearchFormSuggestDataProviderOptions({
    field,
    suggests,
    language,
    nationalVersion,
    clientSettlement,
    from,
    to,
    transportType,
}) {
    return {
        url: suggests.url,
        credentials: suggests.credentials,
        path: getSuggestsType(transportType),
        query: {
            field,
            lang: language,
            format: 'old',
            t_type_code: transportType !== ALL_TYPE ? transportType : null,
            other_point: field === 'from' ? to.key : from.key,
            national_version: nationalVersion === 'ua' ? 'ua' : 'ru',
            client_city: clientSettlement.geo_id,
        },
    };
}
