import 'whatwg-fetch';

import TSuggestDataProvider from '../../interfaces/lib/suggests/TSuggestDataProvider';

import makeExternalUrl from '../url/makeExternalUrl';
import getItemsFromResponse from './getItemsFromResponse';

const defaultDataProvider: TSuggestDataProvider = (
    part: string, // По задумке автора это основной query-параметр для запроса, т.е. будет добавлен get-параметр "path" в запрос
    {url, path = '', query = {}, credentials = 'same-origin'},
) => {
    const fullUrl = makeExternalUrl(`${url}${path}`, {
        ...query,
        part,
    });

    return fetch(fullUrl, {mode: 'cors', credentials})
        .then(response => response.json())
        .then(json => getItemsFromResponse(json));
};

export default defaultDataProvider;
