import NationalVersion from '../../interfaces/NationalVersion';
import ISettlement from '../../interfaces/state/settlement/ISettlement';
import IStateSuggests from '../../interfaces/state/IStateSuggests';
import Lang from '../../interfaces/Lang';
import ISuggestDataProviderOptions from '../../interfaces/lib/suggests/ISuggestDataProviderOptions';

interface IGetDataProviderOptions {
    nationalVersion: NationalVersion;
    settlement: ISettlement; // Населенный пункт клиента
    suggests: IStateSuggests; // Объект с ссылкой на url, от которого можно получить подсказки
    language: Lang;
    path: string; // Тип получаемых подсказок и путь, по которому делается запрос
}

/** Возвращает параметры для запроса для получения вариантов-подсказок */
export default function getDataProviderOptions({
    nationalVersion,
    settlement,
    suggests,
    language,
    path,
}: IGetDataProviderOptions): ISuggestDataProviderOptions | undefined {
    if (!suggests || !settlement || !path) {
        return undefined;
    }

    return {
        url: suggests.url,
        credentials: suggests.credentials,
        path,
        query: {
            lang: language,
            format: 'old',
            national_version:
                nationalVersion === NationalVersion.ua
                    ? NationalVersion.ua
                    : NationalVersion.ru,
            client_city: settlement.geo_id,
        },
    };
}
