import IBreadcrumb from '../../interfaces/IBreadcrumb';
import {FilterTransportType} from '../transportType';
import Tld from '../../interfaces/Tld';
import Lang from '../../interfaces/Lang';

import getCanonicalSearchUrl from '../url/getCanonicalSearchUrl';

import breadcrumbsKeyset from '../../i18n/breadcrumbs/index';

interface IGetSearchBreadCrumb {
    transportType: FilterTransportType;
    tld: Tld;
    language: Lang;
    titleFrom: string;
    titleTo: string;

    fromSlug?: string;
    toSlug?: string;
}

export default function getBreadCrumbFromThreadToSearch({
    transportType,
    tld,
    language,
    titleFrom,
    titleTo,

    fromSlug,
    toSlug,
}: IGetSearchBreadCrumb): IBreadcrumb | null {
    if (
        transportType === FilterTransportType.all ||
        transportType === FilterTransportType.plane ||
        transportType === FilterTransportType.water ||
        !fromSlug ||
        !toSlug
    ) {
        return null;
    }

    let title = '';

    switch (transportType) {
        case FilterTransportType.train:
            title = breadcrumbsKeyset('to-train-search-page', {
                from: titleFrom,
                to: titleTo,
            });
            break;
        case FilterTransportType.bus:
            title = breadcrumbsKeyset('to-bus-search-page', {
                from: titleFrom,
                to: titleTo,
            });
            break;
        case FilterTransportType.suburban:
            title = breadcrumbsKeyset('to-suburban-search-page', {
                from: titleFrom,
                to: titleTo,
            });
            break;
    }

    return {
        url: getCanonicalSearchUrl({
            transportType,
            fromSlug,
            toSlug,
            tld,
            language,
        }),
        name: title,
    };
}
