import threadKeyset from '../../i18n/thread';

export default function getSeatsTitle(
    seatsCount: number | undefined = 0,
): string {
    if (seatsCount < 15 && seatsCount > 10) {
        return Number.isInteger(seatsCount)
            ? threadKeyset.get('zero-or-many-seats')
            : '';
    }

    const seatsTitles = {
        0: threadKeyset.get('zero-or-many-seats'),
        1: threadKeyset.get('one-seat'),
        2: threadKeyset.get('few-seats'),
        3: threadKeyset.get('few-seats'),
        4: threadKeyset.get('few-seats'),
        5: threadKeyset.get('zero-or-many-seats'),
        6: threadKeyset.get('zero-or-many-seats'),
        7: threadKeyset.get('zero-or-many-seats'),
        8: threadKeyset.get('zero-or-many-seats'),
        9: threadKeyset.get('zero-or-many-seats'),
    };
    const lastDigit = seatsCount % 10;

    return seatsTitles[lastDigit] || '';
}
