export function timeoutPromise(timeout = 0) {
    return new Promise(resolve => setTimeout(resolve, timeout));
}

export function incrementalTimeoutPromise(
    retryNumber,
    timeout = 1000,
    maxTimeout = 4000,
) {
    const time = Math.pow(2, retryNumber) * timeout;

    return timeoutPromise(time > maxTimeout ? maxTimeout : time);
}

export function getIncrementalTimeoutPromise(
    timeout = 1000,
    maxTimeout = 4000,
) {
    return retryNumber =>
        incrementalTimeoutPromise(retryNumber, timeout, maxTimeout);
}
