import NationalVersion from '../../interfaces/NationalVersion';

import updateQuery from './updateQuery';

function getUtmParameters(
    natioanlVersion: NationalVersion,
): Record<string, string> {
    const prefix = natioanlVersion === NationalVersion.ua ? 'UA' : 'RU';

    return {
        comuto_cmkt: `${prefix}_YANDEXRASP_PSGR_MAIN_none`,
        utm_source: 'YANDEXRASP',
        utm_medium: 'Link',
        utm_campaign: `${prefix}_YANDEXRASP_PSGR_MAIN_none`,
    };
}

// link - ссылка, полученная от бекенда из ручки server/api/blablacarCityLink.ts
export default function addUtmTagsToBlablacarCityLink(
    link: string,
    nationalVersion: NationalVersion,
): string {
    if (!link) {
        return link;
    }

    return updateQuery(link, getUtmParameters(nationalVersion));
}
