import ALTERNATE_LANGUAGE_DOMAINS from './alternateLanguageDomains';

import Platform from '../../interfaces/Platform';
import IMetaLink from '../../interfaces/lib/meta/IMetaLink';
import IStatePage from '../../interfaces/state/IStatePage';
import AlternateLanguageDomains from '../../interfaces/lib/url/AlternateLanguageDomains';

import makeExternalUrl from './makeExternalUrl';

interface IGetAlternateLanguageLinks {
    page: IStatePage;
    platform: Platform;

    path?: string; // относительный путь в урл (если не передан, то будет взят pathname из page)
    languageDomains?: AlternateLanguageDomains[]; // массив с объектами данных о доменах и языках
}

// Возвращает набор альтернативных ссылок для национальных доменов
export function getAlternateLanguageLinks({
    page,
    platform,

    path = '',
    languageDomains = ALTERNATE_LANGUAGE_DOMAINS,
}: IGetAlternateLanguageLinks): IMetaLink[] {
    const {protocol, pathname} = page.location;
    let touchSubDomain = '';

    if (platform === Platform.mobile) {
        touchSubDomain = 't.';
    }

    return languageDomains.map(({host, query, hreflang}) => ({
        rel: 'alternate',
        href: makeExternalUrl(
            `${protocol}//${touchSubDomain}${host}${path || pathname}`,
            query,
        ),
        hreflang,
    }));
}

// Возвращает альтернативную ссылку на мобильную версию
export function getTouchAlternateLink(
    fullUrl: string, // полный путь страницы
): IMetaLink {
    const url = new URL(fullUrl);

    url.hostname = url.hostname.replace('rasp', 't.rasp');

    const href = url.toString();

    return {
        media: 'only screen and (max-width: 640px)',
        rel: 'alternate',
        href,
    };
}
