import {UTM_SOURCE} from './constants';

import IStateSeoQueryParams from '../../interfaces/state/IStateSeoQueryParams';

import updateQuery from './updateQuery';
import getUtmCampaign from './getUtmCampaign';
import isYandexLink from './isYandexLink';

type IUtmQuery = {
    utm_source: string;
    utm_campaign: string;

    utm_content?: string;
    utm_medium?: string;
    req_id?: string;
    wizardReqId?: string; // Добавлен для https://st.yandex-team.ru/RASPFRONT-8575
};

export default function applyUtm(
    url: string,

    seoQueryParams?: IStateSeoQueryParams,
    clientId?: string,
    utmMedium?: string,
    utmSource: string = UTM_SOURCE,
): string {
    if (!isYandexLink(url)) {
        return url;
    }

    const {reqId} = seoQueryParams || {};
    const query: IUtmQuery = {
        utm_source: utmSource,
        utm_campaign: getUtmCampaign(seoQueryParams),
        utm_content: clientId,
        req_id: reqId,
        wizardReqId: reqId,
    };

    if (utmMedium) {
        query.utm_medium = utmMedium;
    }

    return updateQuery(url, query);
}
