import IBreadcrumb from '../../../interfaces/IBreadcrumb';
import IJsonLdCrumbs from '../../../interfaces/IJsonLdCrumbs';

export default function getJsonLdCrumbs(
    breadcrumbs: IBreadcrumb[],
): IJsonLdCrumbs {
    return {
        '@context': 'http://schema.org',
        '@type': 'BreadcrumbList',
        itemListElement: breadcrumbs.map(({url, name}, index) => ({
            '@type': 'ListItem',
            position: index + 1,
            item: {
                '@id': url,
                name,
            },
        })),
    };
}
