import IJsonLdCrumbs from '../../../interfaces/IJsonLdCrumbs';
import ISearchContext from '../../../interfaces/state/search/ISearchContext';
import Tld from '../../../interfaces/Tld';
import Lang from '../../../interfaces/Lang';
import IStatePage from '../../../interfaces/state/IStatePage';
import ISearchFiltering from '../../../interfaces/state/search/ISearchFiltering';

import getCrumbs from './getCrumbs';

/**
 * Возвращает структуру хлебных крошек в формате JSON-LD
 * https://yandex.ru/support/webmaster/json-ld/about.xml
 * @param {Object} context - поисковый контекст
 * @param {string} tld
 * @param {string} language
 * @param {Object} page - данные страницы
 * @param {Object | undefined} filtering
 * @return {Object}
 */
export default function getJsonLdCrumbsForSearchPage(
    context: ISearchContext,
    tld: Tld,
    language: Lang,
    page: IStatePage,
    filtering: ISearchFiltering,
): IJsonLdCrumbs {
    return {
        '@context': 'http://schema.org',
        '@type': 'BreadcrumbList',
        itemListElement: getCrumbs(context, tld, language, page, filtering).map(
            (value, index) => {
                const {url, name} = value || {};

                return {
                    '@type': 'ListItem',
                    position: index + 1,
                    item: {
                        '@id': url,
                        name,
                    },
                };
            },
        ),
    };
}
