import Tld from '../../../interfaces/Tld';
import Lang from '../../../interfaces/Lang';
import IStatePage from '../../../interfaces/state/IStatePage';
import IStateStation from '../../../interfaces/state/station/IStateStation';
import IJsonLdCrumbs from '../../../interfaces/IJsonLdCrumbs';
import IStateFlags from '../../../interfaces/state/flags/IStateFlags';

import getStationBreadcrumbs from '../../station/getStationBreadcrumbs';
import getJsonLdCrumbs from './getJsonLdCrumbs';

export default function getJsonLdCrumbsForStationPage(
    tld: Tld,
    language: Lang,
    page: IStatePage,
    station: IStateStation,
    flags: IStateFlags,
): IJsonLdCrumbs {
    const {
        type,
        id,
        title,
        currentSubtype,
        mainSubtype,
        settlement,
        event,
        cityData,
        terminals,
        terminalName,
    } = station;
    const {cityStations} = cityData || {};
    const {originUrl, fullUrl} = page;

    const terminal =
        terminals &&
        terminals.find(
            terminalObj =>
                terminalObj.name === terminalName ||
                terminalObj.id === Number(terminalName),
        );

    return getJsonLdCrumbs(
        getStationBreadcrumbs(
            id,
            title,
            type,
            tld,
            language,
            flags,
            currentSubtype,
            mainSubtype,
            settlement,
            event,
            cityStations,
            terminal,
        ).map(({url, name}) => {
            return {
                url: url ? `${originUrl}${url}` : fullUrl,
                name,
            };
        }),
    );
}
