import Tld from '../../interfaces/Tld';
import Lang from '../../interfaces/Lang';

import makeUrl from './makeUrl';

// Возвращает url для направления
export default function directionUrl(
    direction: string, // код направления
    cityId: number, // id города
    isMobile: boolean, // используется ли мобильная версия
    tld: Tld,
    language: Lang,
): string {
    const route = isMobile ? '' : `/city/${cityId}`;

    return makeUrl(`${route}/direction`, tld, language, {direction});
}
