import Tld from '../../interfaces/Tld';
import Lang from '../../interfaces/Lang';

import makeUrl from './makeUrl';

interface IYandexAviaUrlProps {
    yandexAviaUrl: string;
}

interface ICompanyIdProps {
    id: number;
    tld: Tld;
    language: Lang;
}

function getAviaCompanyLink(props: IYandexAviaUrlProps): string;
function getAviaCompanyLink(props: ICompanyIdProps): string;
function getAviaCompanyLink(
    props: IYandexAviaUrlProps | ICompanyIdProps,
): string {
    if ('yandexAviaUrl' in props) {
        const {yandexAviaUrl} = props;

        return yandexAviaUrl;
    }

    const {id, tld, language} = props;

    return makeUrl(`/info/company/${id}`, tld, language);
}

export default getAviaCompanyLink;
