import Direction from '../../interfaces/Direction';
import Tld from '../../interfaces/Tld';
import Lang from '../../interfaces/Lang';
import Slug from '../../interfaces/Slug';
import {FilterTransportType} from '../transportType';
import IPopularDirectionPoint from '../../interfaces/state/popularDirections/IPopularDirectionPoint';

import getCanonicalSearchUrl from './getCanonicalSearchUrl';

interface IGetPopularDirectionUrlParams {
    point: IPopularDirectionPoint;
    direction: Direction;
    slug: Slug;
    language: Lang;
    tld: Tld;
}

export default function getCanonicalPopularDirectionUrl({
    point,
    direction,
    slug,
    language,
    tld,
}: IGetPopularDirectionUrlParams): string {
    const fromSlug =
        direction === Direction.from ? point.innerSlug ?? slug : point.slug;
    const toSlug =
        direction === Direction.from ? point.slug : point.innerSlug ?? slug;

    const params = {
        transportType: point.transportType || FilterTransportType.all,
        tld,
        fromSlug,
        toSlug,
        language,
    };

    return getCanonicalSearchUrl(params);
}
