import {FilterTransportType} from '../transportType';
import Tld from '../../interfaces/Tld';
import Lang from '../../interfaces/Lang';
import DateSpecialValue from '../../interfaces/date/DateSpecialValue';

import {getCanonicalUrl} from './searchUrl';

interface IGetCanonicalSearchUrl {
    transportType: FilterTransportType;
    tld: Tld;
    language: Lang;
    fromSlug: string;
    toSlug: string;
}

export default function getCanonicalSearchUrl(
    params: IGetCanonicalSearchUrl,
): string {
    const {transportType, tld, fromSlug, toSlug, language} = params;

    const context = {
        transportType,
        canonical: {
            transportType,
            pointTo: toSlug,
            pointFrom: fromSlug,
        },
        when: {
            special:
                transportType === FilterTransportType.suburban
                    ? DateSpecialValue.today
                    : DateSpecialValue.allDays,
        },
    };

    return getCanonicalUrl(context, tld, language);
}
