import Tld from '../../interfaces/Tld';
import Lang from '../../interfaces/Lang';
import StationType from '../../interfaces/state/station/StationType';
import StationSubtype from '../../interfaces/state/station/StationSubtype';
import StationEventList from '../../interfaces/state/station/StationEventList';
import IStateFlags from '../../interfaces/state/flags/IStateFlags';

import {stationUrl} from './stationUrl';

interface IGetCanonicalStationUrl {
    id: number;
    tld: Tld;
    language: Lang;
    type: StationType;
    flags: IStateFlags;

    subtype?: StationSubtype;
    mainSubtype?: StationSubtype;
    event?: StationEventList;
    terminalName?: string;
}

export default function getCanonicalStationUrl({
    id,
    tld,
    language,
    type,
    flags,

    subtype,
    mainSubtype,
    event,
    terminalName,
}: IGetCanonicalStationUrl): string {
    const mainParameters = {
        id,
        tld,
        language,
        flags,
        type,
    };

    if (type === StationType.bus || type === StationType.water) {
        return stationUrl(mainParameters);
    }

    return stationUrl({
        ...mainParameters,
        // Если не задан главный подтип или подтип это табло, для каноникла игнорируем подтип
        subtype:
            !mainSubtype || subtype === StationSubtype.tablo
                ? undefined
                : subtype,
        mainSubtype,
        terminalName,
        event,
    });
}
