import Tld from '../../interfaces/Tld';

const existsHelpTlds = {
    [Tld.ru]: true,
    [Tld.ua]: true,
    [Tld.kz]: true,
    [Tld.uz]: true,
};

// Для получания ссылки на справку (https://yandex.ru/support/rasp/)
export default function getHelpUrl(tld: Tld): string {
    const tldForUrl = existsHelpTlds[tld] ? tld : Tld.ru;

    return `https://yandex.${tldForUrl}/support/rasp/`;
}
