import makeExternalUrl from './makeExternalUrl';
import getTravelDomain from './getTravelDomain';

interface IGetHotelUrl {
    isProduction: boolean;

    path?: string;
    query?: Record<string, any>;
}

// Вернёт ссылку на вериталь отелей в портале
export default function getHotelUrl({
    isProduction,
    path = '',
    query = {},
}: IGetHotelUrl): string {
    return makeExternalUrl(
        `${getTravelDomain({isProduction})}/hotels${path}`,
        query,
    );
}
