import Tld from '../../interfaces/Tld';
import Lang from '../../interfaces/Lang';

import makeUrl from './makeUrl';

// Возвращает ссылку на статью
export default function getInfoUrl(
    slugOrId: string | number,
    tld: Tld,
    language: Lang,
    path?: string,
): string {
    return makeUrl(
        `/info/${path?.replace(/^\//, '') || ''}${slugOrId}`,
        tld,
        language,
    );
}
