import moment, {Moment} from 'moment';

import {UTM_SOURCE} from './constants';
import {ROBOT} from '../date/formats';

import getPlaneUrl from './getPlaneUrl';
import makeExternalUrl from './makeExternalUrl';

interface IGetPlaneThreadUrl {
    numberPlane: string;

    departure?: string;
    departureFrom?: string;
    departureMoment?: Moment;
    query?: Record<string, any>;
    isProduction?: boolean;
}

export default function getPlaneThreadUrl({
    numberPlane,
    departure,
    departureFrom,
    departureMoment,
    query = {},
    isProduction,
}: IGetPlaneThreadUrl): string {
    const id = numberPlane.replace(/\s/g, '-').trim();
    const path = getPlaneUrl(`/flights/${id}/`, isProduction);
    const planeQuery: Record<string, any> = {
        utm_source: UTM_SOURCE,
        ...query,
    };

    if (departureMoment) {
        planeQuery.when = departureMoment.format(ROBOT);
    } else {
        const whenString = departureFrom || departure;

        if (whenString) {
            planeQuery.when = moment.parseZone(whenString).format(ROBOT);
        }
    }

    return makeExternalUrl(path, planeQuery);
}
