import qs from 'qs';

import GetParameters from '../../interfaces/lib/url/GetParameters';

// Возвращает распарсенный объект с get-параметрами запроса из урла
export default function getQuery<ExpectedKeys extends string = ''>(
    url: string,
): GetParameters<ExpectedKeys> {
    const [beforeHash] = url.split('#');
    const [, queryString] = beforeHash.split('?');

    const query = queryString ? qs.parse(queryString) : {};

    return query;
}
