import {INFORMER_MATCHED_COLORS} from '../informer/constants';

import Tld from '../../interfaces/Tld';
import Lang from '../../interfaces/Lang';
import InformerColor from '../../interfaces/components/informer/InformerColor';
import InformerTheme from '../../interfaces/components/informer/InformerTheme';
import StationEventList from '../../interfaces/state/station/StationEventList';
import StationInformerType from '../../interfaces/components/informer/StationInformerType';

import makeUrl from './makeUrl';

interface IGetStationInformerUrlParams {
    id: number;
    tld: Tld;
    language: Lang;

    size?: number;
    color?: InformerColor;
    theme?: InformerTheme;
    type?: StationInformerType;
    event?: StationEventList;
}

export default function getStationInformerUrl({
    id,
    tld,
    language,

    size,
    color,
    theme,
    type,
    event,
}: IGetStationInformerUrlParams): string {
    const colorId =
        color &&
        Object.keys(INFORMER_MATCHED_COLORS).find(
            key => INFORMER_MATCHED_COLORS[key] === color,
        );

    const query = {
        size,
        color: colorId,
        theme,
        type,
        event: event === StationEventList.arrival ? event : undefined,
    };

    return makeUrl(`/informers/station/${id}`, tld, language, query);
}
