import Tld from '../../interfaces/Tld';
import Lang from '../../interfaces/Lang';
import StationType from '../../interfaces/state/station/StationType';
import StationSubtype from '../../interfaces/state/station/StationSubtype';

import makeUrl from './makeUrl';

const existingSubtypes = [
    StationSubtype.suburban,
    StationSubtype.train,
    StationSubtype.tablo,
];

interface IGetStationInformersUrlParams {
    id: number;
    tld: Tld;
    language: Lang;

    type?: StationType;
    subtype?: StationSubtype;
    originUrl?: string;
}

// Возвращает ссылку на страницу с информером
export default function getStationInformersUrl({
    id,
    tld,
    language,

    type,
    subtype,
    originUrl,
}: IGetStationInformersUrlParams): string {
    const typeForUrl =
        type === StationType.plane
            ? StationSubtype.tablo
            : subtype && existingSubtypes.includes(subtype)
            ? subtype
            : undefined;

    return makeUrl(`${originUrl || ''}/informers/`, tld, language, {
        station: id,
        type: typeForUrl,
    });
}
