import makeExternalUrl from './makeExternalUrl';
import getTravelDomain from './getTravelDomain';

interface IGetTrainUrl {
    isProduction: boolean;

    path?: string;
    query?: Record<string, any>;
}

// Вернёт ссылку на покупку жд билетов
export default function getTrainUrl({
    isProduction,
    path = '',
    query = {},
}: IGetTrainUrl): string {
    return makeExternalUrl(
        `${getTravelDomain({isProduction})}/trains${path}`,
        query,
    );
}
