import Slug from '../../interfaces/Slug';
import DateRobot from '../../interfaces/date/DateRobot';

import getTrainUrl from './getTrainUrl';

export function getTravelTrainsSearchUrl(
    context: {
        fromSlug: Slug;
        toSlug: Slug;
        when?: DateRobot;
    },
    isProduction: boolean,
): string {
    return getTrainUrl({
        isProduction,
        path: `/${context.fromSlug}--${context.toSlug}/`,
        query: context.when ? {when: context.when} : {},
    });
}
