import isPlaneObject from 'lodash/isPlainObject';

// Проверяет, что get-параметр для url имеет какое-либо значение.
// Если такого значения нет, то как правило, нет смысла вставлять его в ссылку.
export default function hasValue(value: any): boolean {
    if (Array.isArray(value)) {
        return Boolean(value.length) && value.some(item => hasValue(item));
    }

    if (value === '' || value === undefined || value === null) {
        return false;
    }

    if (isPlaneObject(value) && Object.keys(value).length === 0) {
        return false;
    }

    return true;
}
