// Отвечает, является ли урл ссылкой на другой сервис Яндекса (не Расписания)
export default function isAnotherYandexService(url: string): boolean {
    if (!url) {
        return false;
    }

    const match = url.match(
        /^(?:.*\/\/)?([\w.-]*\.)?yandex\.[a-z]{2}(?:\/|\?|#|$)/,
    );

    if (!match) {
        return false;
    }

    const subdomain = match[1];

    // Если поддомена нет, то это ссылка на главную Яндекса
    return !subdomain || !subdomain.split('.').includes('rasp');
}
