import Tld from '../../interfaces/Tld';
import Lang from '../../interfaces/Lang';

import makeExternalUrl from './makeExternalUrl';

export default function langSwitchUrl(
    tld: Tld,
    language: Lang,
    fullUrl: string,
    secretkey: string | null,
): string {
    const url = `//www.yandex.${tld}/portal/set/lang/`;

    const query = {
        retpath: fullUrl,
        sk: secretkey,
        intl: language,
    };

    return makeExternalUrl(url, query);
}
