import qs from 'qs';

import Query from '../../interfaces/lib/url/Query';

import qsStringifyConfig from './qsStringifyConfig';

// Возвращает ссылку для внешнего ресурса.
export default function makeExternalUrl(
    path: string,
    query: Query | undefined = {},
): string {
    return `${path}${qs.stringify(query, qsStringifyConfig)}`;
}
