import qs from 'qs';

import Tld from '../../interfaces/Tld';
import Lang from '../../interfaces/Lang';
import Query from '../../interfaces/lib/url/Query';

import getNationalLanguage from '../lang/getNationalLanguage';
import qsStringifyConfig from './qsStringifyConfig';

// Генерирует ВНУТРЕННЮЮ ссылку на основе базовой ссылки и GET-параметров.
// Данную функию следует использовать только для ссылок внутри rasp.yandex.tld
// Для ссыдлк на внешние ресурсы есть makeExternalUrl.
export default function makeUrl(
    path: string,
    tld: Tld, // текущий домен верхнего уровня из store
    language: Lang, // текущий язык интерфейса из store
    query: Query | undefined = {},

    sort?: (a: string, b: string) => number, // кастомная сортировка для параметров запроса
): string {
    const nationalLanguage = getNationalLanguage(tld);
    const qsConfig = sort
        ? {
              ...qsStringifyConfig,
              sort,
          }
        : qsStringifyConfig;

    query.lang = nationalLanguage !== language ? language : undefined;

    return `${path}${qs.stringify(query, qsConfig)}`;
}
