import {Moment} from 'moment';

import {ROBOT} from '../date/formats';

import IPoint from '../../interfaces/state/searchForm/IPoint';
import Lang from '../../interfaces/Lang';
import IStateSeoQueryParams from '../../interfaces/state/IStateSeoQueryParams';
import CurrencyCode from '../../interfaces/CurrencyCode';

import applyUtm from './applyUtm';
import makeExternalUrl from './makeExternalUrl';
import getTravelDomain from './getTravelDomain';

interface IPlaneOrderUrl {
    from: IPoint;
    to: IPoint;
    when: Moment;
    number: string;
    departure: Moment;
    isProduction: boolean;

    language?: Lang;
    currency?: CurrencyCode;
    utmMedium?: string;
    clientId?: string;
    seoQueryParams?: IStateSeoQueryParams;
}

export default function planeOrderUrl({
    from,
    to,
    when,
    number,
    departure,
    isProduction,

    language,
    currency = CurrencyCode.rub,
    utmMedium,
    clientId,
    seoQueryParams,
}: IPlaneOrderUrl): string {
    const formattedWhen = when.format(ROBOT);
    const forward = `${number}.${formattedWhen}T${departure.format('HH:mm')}`;

    const url = makeExternalUrl(
        `${getTravelDomain({isProduction})}/avia/order/`,
        {
            fromId: from.key,
            toId: to.key,
            when: formattedWhen,
            forward,
            lang: language,
            currency,
        },
    );

    return applyUtm(url, seoQueryParams, clientId, utmMedium);
}
