import omit from 'lodash/omit';

import IStateSearchForm from '../../interfaces/state/IStateSearchForm';
import IStatePage from '../../interfaces/state/IStatePage';
import Tld from '../../interfaces/Tld';
import Lang from '../../interfaces/Lang';

import makeUrl from './makeUrl';
import searchUrl from './searchUrl';
import getPath from './getPath';
import getQuery from './getQuery';

interface IGetAllDaySearchUrlToRedirect {
    searchForm: IStateSearchForm;
    page: IStatePage;
    tld: Tld;
    language: Lang;
}

/**
 * Функция возвращает поисковый урл на все дни на основе slug'ов для редиректа
 * @param {string} searchForm - поисковая форма
 * @param {string} page - страница из стора
 * @return {string} - новый урл
 */
export default function getAllDaySearchUrlToRedirect({
    searchForm,
    page,
    tld,
    language,
}: IGetAllDaySearchUrlToRedirect): string {
    const query = page.location.query;
    const queryFromOldUrl = omit(query, [
        'fromName',
        'fromId',
        'toName',
        'toId',
        'when',
    ]);

    const searchUrlString = searchUrl({context: searchForm}, tld, language);
    const path = getPath(searchUrlString);
    const queryFromSearchUrl = getQuery(searchUrlString);

    return makeUrl(path, tld, language, {
        ...queryFromOldUrl,
        ...queryFromSearchUrl,
    });
}
