import {TRANSPORT_CITY_TRANSPORT_TYPES} from '../transportType';

// eslint-disable-next-line no-duplicate-imports
import {TransportType} from '../transportType';

interface IBuildTransportCityUrl {
    transportType: TransportType;
    slug: string;

    originUrl?: string;
}

export default function buildTransportCityUrl({
    slug,
    transportType,
    originUrl = '',
}: IBuildTransportCityUrl): string | null {
    if (
        !slug ||
        !transportType ||
        !TRANSPORT_CITY_TRANSPORT_TYPES.includes(transportType)
    ) {
        return null;
    }

    return `${originUrl}/${transportType}/${slug}`;
}
