import {TRANSPORT_PAGE_TRANSPORT_TYPES} from '../transportType';

// eslint-disable-next-line no-duplicate-imports
import {TransportType} from '../transportType';

interface IBuildTransportUrl {
    transportType: TransportType;

    originUrl?: string;
}

export default function buildTransportUrl({
    transportType,
    originUrl = '',
}: IBuildTransportUrl): string | null {
    if (
        !transportType ||
        !TRANSPORT_PAGE_TRANSPORT_TYPES.includes(transportType)
    ) {
        return null;
    }

    return `${originUrl}/${transportType}`;
}
