import {momentTimezone as moment} from '../../../reexports';
import {Moment} from 'moment';

import {RU_LOCALE_DATE} from '../date/formats';

import ISegment from '../../interfaces/segment/ISegment';

import makeExternalUrl from './makeExternalUrl';

export const UFS_LINK = 'https://www.ufs-online.ru/kupit-zhd-bilety';
export const DOMAIN = 'yandex.ufs-online.ru';

// Возвращает ссылку покупки на УФС
export default function getUfsBuyLink(
    segment: ISegment,
    dayMoment?: Moment, // Дата отправляния. Задается для формирования ссылки на определенную дату
): string | null {
    const {stationTo, stationFrom, number, departure} = segment;

    if (!stationFrom.codes || !stationTo.codes) {
        return null;
    }

    const path = `${UFS_LINK}/${stationFrom.codes.express}/${stationTo.codes.express}`;
    const date = (
        (dayMoment && dayMoment.parseZone()) ||
        moment.tz(departure, stationFrom.timezone)
    ).format(RU_LOCALE_DATE);

    return makeExternalUrl(path, {
        date,
        trainNumber: number,
        domain: DOMAIN,
    });
}
