import qs from 'qs';

import Query from '../../interfaces/lib/url/Query';

import qsStringifyConfig from './qsStringifyConfig';

// Добавляет, заменяет или удаляет параметры строки запроса
export default function updateQuery(url: string, query: Query): string {
    const [beforeHash, hash] = url.split('#');
    const [path, queryString] = beforeHash.split('?');

    const oldQuery = queryString ? qs.parse(queryString) : {};
    const newQuery = qs.stringify({...oldQuery, ...query}, qsStringifyConfig);

    return path + newQuery + (hash ? `#${hash}` : '');
}
