import ISegmentTariffClass from '../../interfaces/segment/ISegmentTariffClass';

import makeExternalUrl from './makeExternalUrl';

export const BEST_OFFER_MEDIUM = 'best_offer';
export const SEARCH_SEGMENT_MEDIUM = 'search_segment';
export const SEARCH_SEGMENT_TITLE_MEDIUM = 'search_segment_title';

// ybusUrl - возвращает ссылку на покупу сервиса Я.Автобусы
export default function ybusUrl(
    tariffClass: ISegmentTariffClass,
    medium: string, // utm-метка определяющая элемент по которому кликнули
): string | null {
    const {parsedUrl} = tariffClass;

    if (!parsedUrl) {
        return null;
    }

    const {pathname, query} = parsedUrl;

    return makeExternalUrl(pathname, {
        ...query,
        utm_medium: medium,
    });
}
