import {useState, MutableRefObject, useRef, useEffect} from 'react';

export default function useVisibility(
    offset = 0,
): [boolean, MutableRefObject<HTMLDivElement>] {
    const [isVisible, setIsVisible] = useState(true);
    const currentElement = useRef(
        null,
    ) as unknown as MutableRefObject<HTMLDivElement>;

    const onScroll = (): void => {
        if (!currentElement.current) {
            setIsVisible(false);

            return;
        }

        const top = currentElement.current.getBoundingClientRect().top;

        setIsVisible(top + offset >= 0 && top - offset <= window.innerHeight);
    };

    useEffect(() => {
        document.addEventListener('scroll', onScroll, true);

        return () => document.removeEventListener('scroll', onScroll, true);
    });

    return [isVisible, currentElement];
}
