import IParams from '../interfaces/lib/yaMetrika/IParams';
import IHitOptions from '../interfaces/lib/yaMetrika/IHitOptions';

export enum MetrikaCode {
    METRIKA_COUNTER_CODE = 99704,
    METRIKA_TOUCH_COUNTER_CODE = 22352497,
}

const uniqGoals = new Set();

export function reachGoal(
    target: string,
    parameters?: IParams | IParams[],
    callback?: () => void,
    ctx?: object,
): void {
    if (typeof window === 'undefined') {
        return;
    }

    if (window.yaCounter) {
        setTimeout(
            () => window.yaCounter.reachGoal(target, parameters, callback, ctx),
            0,
        );
    } else {
        // Если счетчик еще не был инициализован, добавить событие в очередь
        if (window.yaCounterQueue === undefined) {
            window.yaCounterQueue = [];
        }

        window.yaCounterQueue.push({
            target,
            props: [parameters, callback, ctx].filter(arg => arg !== undefined),
        });
    }
}

export function reachGoalOnce(
    target: string,
    parameters?: IParams | IParams[],
    callback?: () => void,
    ctx?: object,
): void {
    if (typeof window === 'undefined') {
        return;
    }

    if (!uniqGoals.has(target)) {
        uniqGoals.add(target);
        reachGoal(target, parameters, callback, ctx);
    }
}

export function clearUniqGoals(): void {
    uniqGoals.clear();
}

export function command(
    methodName: string,
    parameters?: IParams | IParams[],
    callback?: () => void,
    ctx?: object,
): void {
    if (typeof window !== 'undefined' && window.yaCounter) {
        setTimeout(
            () => window.yaCounter[methodName](parameters, callback, ctx),
            0,
        );
    }
}

export function hit(url: string, options: IHitOptions = {}): void {
    const callback = (): void => {
        clearUniqGoals();

        if (options.callback) {
            options.callback.apply(options.ctx);
        }
    };

    if (typeof window !== 'undefined' && window.yaCounter) {
        setTimeout(
            () =>
                window.yaCounter.hit(url, {
                    ...options,
                    callback,
                }),
            0,
        );
    } else {
        callback();
    }
}

export function params(args: IParams | IParams[]): void {
    if (typeof window !== 'undefined' && window.yaCounter) {
        setTimeout(() => window.yaCounter.params(args), 0);
    }
}

export function getClientId(): string | undefined {
    if (typeof window !== 'undefined' && window.yaCounter) {
        return window.yaCounter.getClientID();
    }
}

export function getCounterCode(isTouch: boolean): MetrikaCode {
    return isTouch
        ? MetrikaCode.METRIKA_TOUCH_COUNTER_CODE
        : MetrikaCode.METRIKA_COUNTER_CODE;
}

export function getInitEventId(isTouch: boolean): string {
    return `yacounter${getCounterCode(isTouch)}inited`;
}

export function onMetrikaInit(callback, isTouch: boolean): void {
    if (typeof window !== 'undefined' && window.yaCounter) {
        callback();
    } else {
        document.addEventListener(getInitEventId(isTouch), callback);
    }
}
